/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.plugin;

import de.willuhn.datasource.BeanUtil;
import de.willuhn.jameica.messaging.QueryMessage;
import de.willuhn.jameica.plugin.Manifest;
import de.willuhn.jameica.plugin.Plugin;
import de.willuhn.jameica.plugin.PluginResources;
import de.willuhn.jameica.plugin.Version;
import de.willuhn.jameica.system.Application;
import de.willuhn.util.ApplicationException;
import de.willuhn.util.MultipleClassLoader;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;

public class PlaceholderPlugin
implements Plugin {
    private PluginResources res = new PluginResources(this);
    private Manifest manifest = null;

    private PlaceholderPlugin(Manifest manifest) {
        this.manifest = manifest;
    }

    public static Plugin createInstance(Manifest manifest) {
        PlaceholderInvocationHandler handler = new PlaceholderInvocationHandler(new PlaceholderPlugin(manifest));
        MultipleClassLoader loader = manifest.getClassLoader();
        return (Plugin)Proxy.newProxyInstance((ClassLoader)(loader != null ? loader : Application.getClassLoader()), new Class[]{Plugin.class}, (InvocationHandler)handler);
    }

    @Override
    public PluginResources getResources() {
        return this.res;
    }

    @Override
    public Manifest getManifest() {
        return this.manifest;
    }

    @Override
    public void init() throws ApplicationException {
        Application.getMessagingFactory().getMessagingQueue("plugin." + this.manifest.getName() + ".init").sendSyncMessage(new QueryMessage(this));
    }

    @Override
    public void install() throws ApplicationException {
        Application.getMessagingFactory().getMessagingQueue("plugin." + this.manifest.getName() + ".install").sendSyncMessage(new QueryMessage(this));
    }

    @Override
    public void update(Version oldVersion) throws ApplicationException {
        Application.getMessagingFactory().getMessagingQueue("plugin." + this.manifest.getName() + ".update").sendSyncMessage(new QueryMessage(new Object[]{this, oldVersion}));
    }

    @Override
    public void shutDown() {
        Application.getMessagingFactory().getMessagingQueue("plugin." + this.manifest.getName() + ".shutdown").sendSyncMessage(new QueryMessage(this));
    }

    @Override
    public void uninstall(boolean deleteUserData) throws ApplicationException {
        Application.getMessagingFactory().getMessagingQueue("plugin." + this.manifest.getName() + ".uninstall").sendSyncMessage(new QueryMessage(new Object[]{this, deleteUserData}));
    }

    private static class PlaceholderInvocationHandler
    implements InvocationHandler {
        private Plugin redirect = null;

        private PlaceholderInvocationHandler(Plugin redirect) {
            this.redirect = redirect;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            return BeanUtil.invoke((Object)this.redirect, (String)method.getName(), (Object[])args);
        }
    }
}

